#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_MsBos : BaseTest 
	{

		[SetUp]
		protected void SetUp() 
		{
			this.BaseSetUp();
		}

       
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)] 
		public void Save_Pass()
		{	
			//Call directly to Common.StoredProcedure.TransactionalGetValue -- See those unit tests
		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Save_Fail()
		{
			//Call directly to Common.StoredProcedure.TransactionalGetValue -- See those unit tests
		}

		[Test]
		public void GetOrderableComponentClasses_Pass()
		{			
			DataTable dtTest = DAL.Msbos.GetOrderableComponentClasses();

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(2, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassId), TABLES.ComponentClass.ComponentClassId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassName), TABLES.ComponentClass.ComponentClassName);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetOrderableComponentClasses_Fail()
		{			
		}

		
		[Test]
		public void GetMSBOSEntries_Pass()
		{			
			DataSet dsTest = DAL.Msbos.GetMsbosEntries();

			Assert.AreEqual(2, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(8, dsTest.Tables[0].Columns.Count, "Columns[0].Count");
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.Msbos.MsbosGuid), "[o]-" + TABLES.Msbos.MsbosGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.Msbos.SurgeryName), "[o]-" + TABLES.Msbos.SurgeryName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.Msbos.TypeAndScreenIndicator), "[o]-" + TABLES.Msbos.TypeAndScreenIndicator);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.Msbos.NoBloodRequiredIndicator), "[o]-" + TABLES.Msbos.NoBloodRequiredIndicator);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.Msbos.DivisionCode), "[o]-" + TABLES.Msbos.DivisionCode);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.Msbos.RecordStatusCode), "[o]-" + TABLES.Msbos.RecordStatusCode);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.Msbos.LastUpdateUser), "[o]-" + TABLES.Msbos.LastUpdateUser);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.Msbos.RowVersion), "[o]-" + TABLES.Msbos.RowVersion);

			Assert.AreEqual(8, dsTest.Tables[1].Columns.Count, "Columns[1].Count");
			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.MsbosComponentClass.MsbosComponentClassGuid), "[1]-" + TABLES.MsbosComponentClass.MsbosComponentClassGuid);
			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.MsbosComponentClass.MsbosGuid), "[1]-" + TABLES.MsbosComponentClass.MsbosGuid);
			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.MsbosComponentClass.ComponentClassId), "[1]-" + TABLES.MsbosComponentClass.ComponentClassId);
			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.ComponentClass.ComponentClassName), "[1]-" + TABLES.ComponentClass.ComponentClassName);
			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.MsbosComponentClass.MaximumSetupUnitQuantity), "[1]-" + TABLES.MsbosComponentClass.MaximumSetupUnitQuantity);
			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.MsbosComponentClass.LastUpdateUser), "[1]-" + TABLES.MsbosComponentClass.LastUpdateUser);
			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.MsbosComponentClass.RecordStatusCode), "[1]-" + TABLES.MsbosComponentClass.RecordStatusCode);
			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.MsbosComponentClass.RowVersion), "[1]-" + TABLES.MsbosComponentClass.RowVersion);
		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetMSBOSEntries_Fail()
		{			
		}
	}
}
#endif
